<?php
session_start();
if (!isset($_SESSION['admin'])) { header('Location: index.php'); exit; }
require __DIR__ . '/../db.php';
$config = require __DIR__ . '/../config.php';
$p = $pdo->query("SELECT o.*, u.username, u.telegram_id, a.title FROM orders o
                  JOIN users u ON o.user_id=u.id
                  JOIN accounts a ON o.account_id=a.id
                  ORDER BY o.created_at DESC")->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Purchases</title></head><body>
<h2>Purchases</h2>
<table border=1 cellpadding=6>
<tr><th>Order</th><th>User</th><th>Account</th><th>Status</th><th>When</th><th>Actions</th></tr>
<?php foreach($p as $row): ?>
<tr>
  <td>#<?= $row['id'] ?></td>
  <td><?= htmlspecialchars($row['username']) ?> (<?= $row['telegram_id'] ?>)</td>
  <td><?= htmlspecialchars($row['title']) ?></td>
  <td><?= $row['status'] ?></td>
  <td><?= $row['created_at'] ?></td>
  <td>
    <a href="view_purchase.php?id=<?= $row['id'] ?>">View</a> |
    <?php if($row['status'] !== 'paid'): ?>
      <a href="approve.php?id=<?= $row['id'] ?>&action=approve">Approve</a> |
      <a href="approve.php?id=<?= $row['id'] ?>&action=reject">Reject</a>
    <?php endif; ?>
  </td>
</tr>
<?php endforeach; ?>
</table>
<p><a href="accounts_list.php">Back</a></p>
</body></html>