<?php
// bot_functions.php
$config = require __DIR__ . '/config.php';
$BOT_TOKEN = $config['bot_token'];

/*
|--------------------------------------------------------------------------
| Generic JSON API Request
| Works for sendMessage, answerCallbackQuery, editMessageCaption, etc.
| DOES NOT WORK for sendPhoto/sendDocument. (Those use multipart below)
|--------------------------------------------------------------------------
*/
function apiRequest($method, $params = []) {
    global $BOT_TOKEN;

    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/{$method}";
    $body = json_encode($params);

    $opts = [
        'http' => [
            'method'  => 'POST',
            'header'  => "Content-Type: application/json\r\n",
            'content' => $body,
            'timeout' => 15
        ]
    ];

    $context = stream_context_create($opts);
    $response = @file_get_contents($url, false, $context);

    return $response ? json_decode($response, true) : null;
}

/*
|--------------------------------------------------------------------------
| sendMessage() — SAFE
|--------------------------------------------------------------------------
*/
function sendMessage($chat_id, $text, $reply_markup = null) {
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];

    if ($reply_markup) {
        $params['reply_markup'] = is_string($reply_markup)
            ? $reply_markup
            : json_encode($reply_markup);
    }

    return apiRequest('sendMessage', $params);
}

/*
|--------------------------------------------------------------------------
| sendPhoto() — 100% correct multipart/form-data
| This FIXES your “bot not replying on categories” issue.
|--------------------------------------------------------------------------
*/
function sendPhoto($chat_id, $photo, $caption = "", $reply_markup = null) {
    global $BOT_TOKEN;

    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendPhoto";

    // Build the POST request
    $post = [
        "chat_id"    => $chat_id,
        "caption"    => $caption,
        "parse_mode" => "HTML"
    ];

    // If photo is local file → use CURLFile
    if (file_exists($photo)) {
        $post["photo"] = new CURLFile(realpath($photo));
    } else {
        // If URL or File ID → just send as string
        $post["photo"] = $photo;
    }

    // Add reply markup
    if ($reply_markup) {
        $post["reply_markup"] = is_string($reply_markup)
            ? $reply_markup
            : json_encode($reply_markup);
    }

    // cURL request (required for multipart)
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $curl_error = curl_error($ch);
    curl_close($ch);

    if ($curl_error) {
        error_log("sendPhoto cURL error: " . $curl_error);
        return null;
    }

    return json_decode($response, true);
}